function AISMN_CarryGoldToWork::OnEnter(%this,%obj)
{
   %object = GetThisObject(%obj);
   %workplace = GetWorkplace(%obj);
   if(0 != %workplace)
   {
      %component = slgQueryInterface(%workplace, $CID_TARGETBUILDING);
      if (%component != 0)
      {
         %workObj = %component.getEmployeeTarget(%object);
         %workObj.unoccupyHotSpot(%object);
      }
      
      if (SetPathToSpot(%obj, GetBuildingDoorX(%workplace),
         GetBuildingDoorY(%workplace)) == false)
      {
         return;
      }
      
      %object.unmountImage(1);
      %object.unmountImage(2);
      SetSpeedScalar(%obj,0.5);
      %object.mountImage("carrymoneybag",3);
      %object.playThread( 0, "carry");
   }
}

function AISMN_CarryGoldToWork::OnExit(%this,%obj)
{
   GetThisObject(%obj).playThread( 0, "root");
   SetSpeedScalar(%obj,1.0);
   GetThisObject(%obj).unmountImage(3);
   RestoreCharacterOutfit(%obj);
}

//EXIT 0: ARRIVED AT WORK
//EXIT 1: WORK PLACE DOESN'T EXIST
function AISMN_CarryGoldToWork::Update(%this,%obj)
{
   if(GetWorkplace(%obj) == 0)
   {
      ReturnValue(%obj,1);
      return;
   }
   
   if(!IsFollowingPath(%obj))
   {
      ReturnValue(%obj,0);
      return;
   }
   
   ReturnValue(%obj,-1);
}